
library(seasonal)

#####################################################################
############## BUILDING THE ACTIVITY INDEX FOR FINLAND ##############
#####################################################################

##########
## DATA ##
##########

hicp <- ts(read.delim("HICP FIN.txt")[,3], start = 1996, frequency = 12)
const1 <- seas(ts(read.delim("Construction FIN.txt")[,2], start = 1995, frequency = 12), 
              regression.aictest = NULL,
              outlier = NULL,
              transform.function = "none")$data[,1]
const2 <- seas(ts(read.delim("Construction FIN.txt")[,3], start = 1995, frequency = 12), 
               regression.aictest = NULL,
               outlier = NULL,
               transform.function = "none")$data[,1]
const3 <- seas(ts(read.delim("Construction FIN.txt")[,4], start = 1995, frequency = 12), 
               regression.aictest = NULL,
               outlier = NULL,
               transform.function = "none")$data[,1]
const4 <- seas(ts(read.delim("Construction FIN.txt")[,5], start = 1995, frequency = 12), 
               regression.aictest = NULL,
               outlier = NULL,
               transform.function = "none")$data[,1]
const5 <- seas(ts(read.delim("Construction FIN.txt")[,6], start = 1995, frequency = 12), 
               regression.aictest = NULL,
               outlier = NULL,
               transform.function = "none")$data[,1]
const6 <- seas(ts(read.delim("Construction FIN.txt")[,4], start = 1995, frequency = 12), 
               regression.aictest = NULL,
               outlier = NULL,
               transform.function = "none")$data[,1]
bankr1 <- seas(ts(read.delim("Bankruptcies FIN.txt")[,2], start = 1986, frequency = 12), 
              regression.aictest = NULL,
              outlier = NULL,
              transform.function = "none")$data[,1]
bankr2 <- seas(ts(read.delim("Bankruptcies FIN.txt")[,3], start = 1986, frequency = 12), 
              regression.aictest = NULL,
              outlier = NULL,
              transform.function = "none")$data[,1]
sales1 <- ts(read.delim("Sales FIN.txt")[,-1], start = 1995, frequency = 12)
sales <- ts(sales1[13:358,]/hicp[1:346], start = 1996, frequency = 12)
unemp <- ts(read.delim("Unemp FIN.txt")[,3], start = 1988, frequency = 12)
cc <- ts(read.delim("Construction Confidence FIN.txt", na.strings = ":")[,2], start = 1980, frequency = 12)
ic <- ts(read.delim("Industrial Confidence FIN.txt", na.strings = ":")[,2], start = 1980, frequency = 12)
rc <- ts(read.delim("Retail Confidence FIN.txt", na.strings = ":")[,2], start = 1980, frequency = 12)
ConsC <- ts(read.delim("Consumer Confidence FIN.txt", na.strings = ":")[,2], start = 1980, frequency = 12)
sc <- ts(read.delim("Services Confidence FIN.txt", na.strings = ":")[,2], start = 1980, frequency = 12)
ip <- ts(read.delim("Industrial Production FIN.txt", na.strings = ":")[,-1], start = 1995, frequency = 12)
ip_exp1 <- ts(read.delim("Industrial export.txt", na.strings = ":")[,-1], start = 1995, frequency = 12)
ip_exp <- ts(ip_exp1[13:358,]/hicp[1:346], start = 1996, frequency = 12)
wage1 <- ts(read.delim("Wages.txt", na.strings = ":")[,-1], start = 1995, frequency = 12)
wage <- ts(wage1[13:358]/hicp[1:346], start = 1996, frequency = 12)

colnames(sales)

activity_data <- na.omit(cbind(diff(log(const1)), 
                               diff(log(const2)),
                               diff(log(const3)),
                               diff(log(const4)),
                               diff(log(const5)),
                               diff(log(const6)),
                               diff(bankr1), 
                               diff(bankr2), 
                               diff(log(sales)),
                               diff(log(ip_exp)),
                               diff(log(wage)), 
                               diff(unemp),
                               diff(log(ip)) ,diff(cc), diff(ic), diff(rc), diff(ConsC), diff(sc)
                               ))
activity_data
plot(activity_data[,1])

##########################
## PRINCIPAL COMPONENTS ##
##########################
  
activity_index_fin <- prcomp(activity_data, scale. = TRUE, center = TRUE, rank. = 6)
summary(activity_index_fin)

NAI_FIN_diff <- activity_index_fin$x[,1]
NAI_FIN_level <- cumsum(NAI_FIN_diff)

date_sequence <- data.frame(seq(from = as.Date("1997-06-01"), 
                               to = as.Date("2024-10-01"), 
                               by = "1 month"))
which(format(date_sequence, "%Y-%m") == "2008-09")

par(mfrow = c(2,1))
plot(date_sequence, NAI_FIN_diff, type = "l", ylab = "NAI Finland", xlab = "")
abline(h = 0, col = "red")
abline(v = as.Date("2008-09-01"), col = "blue") # Lehman bancruptcy
abline(v = as.Date("2020-04-01"), col = "blue") # Lockdowns
abline(v = as.Date("2022-02-01"), col = "blue") # Lehman bancruptcie

plot(ts(NAI_FIN_level, start = c(1997, 6), frequency = 12), ylab = "NAI Finland cumulative", xlab = "")















